/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.regionalsettings;

import cz.insophy.inplan.util.StringParser;
import cz.insophy.inplan.util.regionalsettings.XmlRegionalSettings;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;

public class StringParserRegionSettings {
    private final DecimalFormat excelDefaultDecimalNumberFormat;
    private final DecimalFormat excelDefaultWholeNumberFormat;
    private final DecimalFormat excelFormattedDecimalNumberFormat;
    private final DecimalFormat excelFormattedWholeNumberFormat;
    private final List<StringParser.DtParser> fuzzyDateParsers;
    private final List<StringParser.DtParser> fuzzyTimeParsers;

    public StringParserRegionSettings(XmlRegionalSettings.Region region) {
        this.excelDefaultDecimalNumberFormat = region.createDecimalFormat("#.##########");
        this.excelDefaultWholeNumberFormat = region.createDecimalFormat("#");
        this.excelFormattedDecimalNumberFormat = region.createDecimalFormat("#,##0.##########");
        this.excelFormattedWholeNumberFormat = region.createDecimalFormat("#,###");
        this.fuzzyDateParsers = this.createDateParsers(region);
        this.fuzzyTimeParsers = this.createTimeParsers(region);
    }

    private List<StringParser.DtParser> createDateParsers(XmlRegionalSettings.Region region) {
        Locale locale = region.getLocale();
        return region.getDateParser().getParsePattern().stream().map(parsePattern -> new StringParser.DtParser(parsePattern.getPattern(), locale, parsePattern.getDuration())).toList();
    }

    private List<StringParser.DtParser> createTimeParsers(XmlRegionalSettings.Region region) {
        Locale locale = region.getLocale();
        return region.getTimeParser().getParsePattern().stream().map(parsePattern -> new StringParser.DtParser(parsePattern.getPattern(), locale, parsePattern.getDuration())).toList();
    }

    public DecimalFormat getExcelDefaultDecimalNumberFormat() {
        return this.excelDefaultDecimalNumberFormat;
    }

    public DecimalFormat getExcelDefaultWholeNumberFormat() {
        return this.excelDefaultWholeNumberFormat;
    }

    public DecimalFormat getExcelFormattedDecimalNumberFormat() {
        return this.excelFormattedDecimalNumberFormat;
    }

    public DecimalFormat getExcelFormattedWholeNumberFormat() {
        return this.excelFormattedWholeNumberFormat;
    }

    public List<StringParser.DtParser> getFuzzyDateParsers() {
        return this.fuzzyDateParsers;
    }

    public List<StringParser.DtParser> getFuzzyTimeParsers() {
        return this.fuzzyTimeParsers;
    }
}

